/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.incident;

import com.ibm.hwmca.fw.pa.PAFilter;
import com.ibm.hwmca.fw.pa.incident.Incident;
import com.ibm.hwmca.fw.pa.incident.IncidentCorrelationFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public final class IncidentPool {
    private HashSet incidents = new HashSet();
    private String poolId = "";

    public IncidentPool() {
    }

    public IncidentPool(String poolId) {
        this.setPoolId(poolId);
    }

    public String getPoolId() {
        return this.poolId;
    }

    public void setPoolId(String poolId) {
        this.poolId = poolId;
    }

    public synchronized boolean add(Incident incident) {
        incident.setContainer(this);
        return this.incidents.add(incident);
    }

    public synchronized boolean remove(Incident incident) {
        boolean removed = this.incidents.remove(incident);
        if (removed) {
            incident.setContainer(null);
        }
        return removed;
    }

    public synchronized void remove(Set incidentSet) {
        Iterator iterator = incidentSet.iterator();
        while (iterator.hasNext()) {
            this.remove((Incident)iterator.next());
        }
    }

    public synchronized Iterator iterator() {
        return ((HashSet)this.incidents.clone()).iterator();
    }

    public synchronized int size() {
        return this.incidents.size();
    }

    public synchronized void clear() {
        this.cancel();
        this.incidents.clear();
    }

    public synchronized void cancel() {
        Iterator iterator = this.incidents.iterator();
        while (iterator.hasNext()) {
            ((Incident)iterator.next()).cancel();
        }
    }

    public boolean contains(Incident incident) {
        return this.incidents.contains(incident);
    }

    public Map correlate(Incident incident, int planeBredth) {
        if (planeBredth < 0) {
            throw new IllegalArgumentException("planeBredth must not be negative");
        }
        HashMap set = new HashMap();
        return set;
    }

    public Set correlate(IncidentCorrelationFilter filter) {
        HashSet<Incident> set = new HashSet<Incident>();
        Iterator iterator = this.incidents.iterator();
        while (iterator.hasNext()) {
            Incident incident = (Incident)iterator.next();
            if (!incident.correlate(filter)) continue;
            set.add(incident);
        }
        return set;
    }

    public synchronized List filter(PAFilter filter) {
        ArrayList theReturnList = new ArrayList();
        ArrayList incidentList = new ArrayList();
        incidentList.addAll(this.incidents);
        filter.filter(theReturnList, Collections.unmodifiableList(incidentList));
        return theReturnList;
    }

    public synchronized List filter(List filterList) {
        ListIterator filterIt = filterList.listIterator();
        ArrayList incidentList = new ArrayList();
        incidentList.addAll(this.incidents);
        List startList = Collections.unmodifiableList(incidentList);
        ArrayList returnList = Collections.EMPTY_LIST;
        while (filterIt.hasNext() && !startList.isEmpty()) {
            returnList = new ArrayList();
            ((PAFilter)filterIt.next()).filter(returnList, startList);
            startList = returnList;
        }
        return returnList;
    }
}

